require "BWOBandit"

BWOVariants = BWOVariants or {}

local soldier = {}

soldier.name = "The Soldier"
soldier.image = "media/textures/Variants/soldier.png"
soldier.desc = "<SIZE:large>The Soldier <BR> "

soldier.desc = soldier.desc .. "<SIZE:medium> Difficulty: Insane <BR> "
soldier.desc = soldier.desc .. "<SIZE:medium>You are part of the military force sent in to contain the Knox Event. "
soldier.desc = soldier.desc .. "You reached the outskirts of West Point, but the bridge over the river is blocked by abandoned vehicles from last night's panic. "
soldier.desc = soldier.desc .. "Advance into the zone and eliminate the infected. <BR> "
soldier.desc = soldier.desc .. " - Start on the outskirts of West Point on Thursday morning. \n "
soldier.desc = soldier.desc .. " - You are part of a squad, armed and prepared for the horrors of the apocalypse. \n "
soldier.desc = soldier.desc .. " - Beware that as the Knox Event escalates, the government will get increasingly reckless... \n "

soldier.timeOfWeek = 6
soldier.timeOfDay = 8.50

soldier.fadeIn = 2500

soldier.fadeIn = 1000

soldier.setup = function()
    local player = getSpecificPlayer(0)
    if not player then return end

    local sx, sy, sz = 12315, 6691, 0
    player:setX(sx)
    player:setY(sy)
    player:setZ(sz)
    player:setLastX(sx)
    player:setLastY(sy)
    player:setLastZ(sz)
	
	local suit = BanditCompatibility.InstanceItem("Base.Jacket_ArmyCamoGreen")
	local suit2 = BanditCompatibility.InstanceItem("Base.Trousers_CamoGreen")
	local shoes = BanditCompatibility.InstanceItem("Base.Shoes_ArmyBoots")
	local goggles = BanditCompatibility.InstanceItem("Base.Hat_GasMask")
	local hat = BanditCompatibility.InstanceItem("Base.Hat_Army")
	local vest = BanditCompatibility.InstanceItem("Base.Vest_BulletArmy")
	local belt = BanditCompatibility.InstanceItem("Base.Belt2")
	local gloves = BanditCompatibility.InstanceItem("Base.Gloves_LeatherGlovesBlack")
	
    local suitloc = suit:getBodyLocation()
	local suit2loc = suit2:getBodyLocation()
	local shoeloc = shoes:getBodyLocation()
	local gogloc = goggles:getBodyLocation()
	local hatloc = hat:getBodyLocation()
	local vestloc = vest:getBodyLocation()
	local beltloc = belt:getBodyLocation()
	local gloveloc = gloves:getBodyLocation()
	
    local inv = player:getInventory()
    local wornItems = player:getWornItems()
    inv:clear()
    wornItems:clear()
	
	inv:AddItem(suit2)
	inv:AddItem(shoes)
	inv:AddItem(goggles)
	inv:AddItem(hat)
	inv:AddItem(vest)
	inv:AddItem(belt)
	inv:AddItem(suit)
	inv:AddItem(gloves)
	
	wornItems:setItem(suit2loc, suit2)
	wornItems:setItem(shoeloc, shoes)
	wornItems:setItem(gogloc, goggles)
	wornItems:setItem(hatloc, hat)
	wornItems:setItem(vestloc, vest)
	wornItems:setItem(beltloc, belt)
	wornItems:setItem(suitloc, suit)
	wornItems:setItem(suit2loc, suit2)
	wornItems:setItem(gloveloc, gloves)
	
    player:setWornItems(wornItems)

    getWorld():update()
    
    local m16 = BanditCompatibility.InstanceItem("Base.AssaultRifle")
	local machete = BanditCompatibility.InstanceItem("Base.Machete")
	local water = BanditCompatibility.InstanceItem("Base.WaterBottle")
	
    inv:AddItem(m16)
	inv:AddItem(machete)
	inv:AddItem(water)
    player:setPrimaryHandItem(m16)
    player:setSecondaryHandItem(m16)

    for i=1, 7 do
        local clip = BanditCompatibility.InstanceItem("Base.556Clip")
        local ammoCnt = clip:getMaxAmmo()
        clip:setCurrentAmmoCount(ammoCnt)
        inv:AddItem(clip)
    end
end

soldier.setup2 = function()
    local player = getSpecificPlayer(0)
    if not player then return end

    local i = 1
    BWOScheduler.Add("ClearZombies", {}, i)
    i = i + 1
    
    local sx, sy, sz = 12316, 6694, 0
    BWOScheduler.Add("SpawnGroupAt", {x=sx, y=sy, z=sz, size=8, program="Companion", hostile=false, cid=Bandit.clanMap.ArmyGreenMask}, i)
    i = i + 1
end

soldier.schedule = {
    [143] = {
        [31] = {"SpawnGroup", {name="Army", cid=Bandit.clanMap.ArmyGreenMask, program="Police", d=50, intensity=5}},
		[32]  = {"HordeAt", {x = 12315, y=6755, z=0, size=20, outfit="Generic01", femaleChance=50}},
        [33]  = {"HordeAt", {x = 12312, y=6769, z=0, size=15, outfit="Generic02", femaleChance=50}},
        [34]  = {"HordeAt", {x = 12317, y=6749, z=0, size=20, outfit="Generic03", femaleChance=50}},
		[35]  = {"HordeAt", {x = 12180, y=6899, z=0, size=40, outfit="Generic01", femaleChance=50}},
		[45] = {"SetupNukes", {}},
        [46] = {"SetupPlaceEvents", {}},
    },
    [144] = {
        [0]  = {"StartDay", {day="thursday"}},
        [3]  =  {"Horde", {x = 0, y=-30, cnt=15}},
        [4]  =  {"Horde", {x = -30, y=-30, cnt=15}},
        [5]  = {"ChopperAlert", {name="heli", sound="BWOChopperPolice1", dir = -90, speed=1.4}},
		[7]  =  {"Horde", {x = -45, y=-35, cnt=15}},
		[9]  =  {"Horde", {x = -35, y=-45, cnt=25}},
		[11]  =  {"Horde", {x = 0, y=35, cnt=30}},
        [12]  =  {"Horde", {x = -35, y=0, cnt=30}},
        [13]  =  {"Horde", {x = 35, y=-35, cnt=20}},
        [14]  =  {"Horde", {x = 35, y=0, cnt=30}},
        [15]  =  {"Horde", {x = 0, y=-35, cnt=20}},
        [30]  = {"Horde", {x = -35, y=35, cnt=30}},
        [31]  =  {"Horde", {x = 0, y=35, cnt=15}},
        [32]  =  {"Horde", {x = -35, y=0, cnt=30}},
        [33]  =  {"Horde", {x = 35, y=-35, cnt=30}},
        [34]  = {"SetHydroPower", {on=false}},
        [35]  = {"JetFighterRun", {arm="gas"}},
		[37] = {"JetFighterRun", {arm="bomb"}},
        [39]  = {"SetHydroPower", {on=true}},
        [40]  =  {"Horde", {x = -35, y=-35, cnt=15}},
        [41]  =  {"Horde", {x = 35, y=-20, cnt=10}},
        [42]  = {"Horde", {x = -35, y=35, cnt=30}},
        [43]  =  {"Horde", {x = 0, y=35, cnt=25}},
        [44]  =  {"Horde", {x = -35, y=0, cnt=20}},
        [45]  =  {"Horde", {x = 35, y=-35, cnt=20}},
        [46]  =  {"Horde", {x = 35, y=0, cnt=15}},
        [47]  =  {"Horde", {x = 0, y=-35, cnt=20}},
        [48]  =  {"Horde", {x = -35, y=-35, cnt=10}},
        [49]  =  {"Horde", {x = 35, y=-20, cnt=20}},
        [50]  = {"SetHydroPower", {on=false}},
        [55]  = {"SetHydroPower", {on=true}},
    },
    [145] = {
        [1]  = {"ChopperFliers", {}},
		[5] = {"Siren", {}},
		[7]  = {"Horde", {x = -35, y=35, cnt=15}},
        [8]  =  {"Horde", {x = 35, y=35, cnt=20}},
        [9]  =  {"Horde", {x = -35, y=0, cnt=20}},
		[30] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=50, intensity=5}},
    },
    [146] = {
        [0]  = {"Siren", {}},
        [5]  = {"JetFighterRun", {arm="mg"}},
        [25] = {"JetFighterRun", {arm="mg"}},
		[30]  = {"Horde", {x = -35, y=35, cnt=15}},
        [32]  =  {"Horde", {x = 35, y=35, cnt=20}},
        [34]  =  {"Horde", {x = -35, y=0, cnt=20}},
        [55]  = {"Siren", {}},
		[56] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=50, intensity=5}},
    },
    [147] = {
        [8]  = {"JetFighterRun", {arm="mg"}},
        [24] = {"JetFighterRun", {arm="mg"}},
        [28] = {"SpawnGroup", {name="Army", cid=Bandit.clanMap.ArmyGreenMask, program="Police", d=51, intensity=5}},
        [47] = {"JetFighterRun", {arm="mg"}},
        [48] = {"Horde", {cnt=100, x=45, y=45}},
        [50] = {"JetFighterRun", {arm="mg"}},
        [51] = {"JetFighterRun", {arm="mg"}},
    },
    [150] = {
        [9]  = {"SpawnGroup", {name="Army", cid=Bandit.clanMap.ArmyGreenMask, program="Police", d=52, intensity=10}},
        [22] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=50, intensity=5}},
        [24] = {"JetFighterRun", {arm="mg"}},
        [27] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=50, intensity=5}},
        [49] = {"JetFighterRun", {arm="mg"}},
        [50] = {"Horde", {cnt=100, x=45, y=45}},
        [58] = {"JetFighterRun", {arm="mg"}},
    },
    [151] = {
        [33] = {"Horde", {cnt=100, x=45, y=45}},
    },
    [152] = {
        [12] = {"JetFighterRun", {arm="mg"}},
        [24] = {"JetFighterRun", {arm="mg"}},
		[46] = {"Horde", {cnt=100, x=45, y=45}},
    },
    [153] = {
        [5] = {"SpawnGroup", {name="Army", cid=Bandit.clanMap.ArmyGreenMask, program="Police", d=53, intensity=5}},
        [6] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=50, intensity=5}},
        [7] = {"SpawnGroup", {name="Army", cid=Bandit.clanMap.ArmyGreenMask, program="Police", d=54, intensity=2}},
        [10]  = {"Siren", {}},
		[15] = {"JetFighterRun", {arm="bomb"}},
		[16] = {"JetFighterRun", {arm="bomb"}},
		[17] = {"JetFighterRun", {arm="bomb"}},
		[18] = {"JetFighterRun", {arm="bomb"}},
		[19] = {"JetFighterRun", {arm="bomb"}},
		[20] = {"JetFighterRun", {arm="bomb"}},
		[21] = {"JetFighterRun", {arm="bomb"}},
		[22] = {"JetFighterRun", {arm="bomb"}},
		[23] = {"JetFighterRun", {arm="bomb"}},
		[24] = {"JetFighterRun", {arm="bomb"}},
		[25] = {"JetFighterRun", {arm="bomb"}},
		[26] = {"JetFighterRun", {arm="bomb"}},
    },
    [154] = {
        [25] = {"SpawnGroup", {name="Army", cid=Bandit.clanMap.ArmyGreenMask, program="Police", d=55, intensity=4}},
        [26] = {"SpawnGroup", {name="Inmates", cid=Bandit.clanMap.InmateFree, program="Bandit", d=55, intensity=14}},
        [27] = {"SpawnGroup", {name="Inmates", cid=Bandit.clanMap.InmateFree, program="Bandit", d=59, intensity=13}},
		[45] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=45, intensity=5}},
		[48] = {"Horde", {cnt=40, x=55, y=-45}},
    },
    [155] = {
        [5]  = {"JetFighterRun", {arm="mg"}},
        [15] = {"JetFighterRun", {arm="mg"}},
        [16] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=49, intensity=3}},
        [17] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=48, intensity=3}},
        [18] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=47, intensity=3}},
        [25] = {"JetFighterRun", {arm="mg"}},
        [26] = {"SpawnGroup", {name="Army", cid=Bandit.clanMap.ArmyGreenMask, program="Police", d=56, intensity=10}},
		[29] = {"Horde", {cnt=40, x=55, y=-45}},
		[45] = {"Horde", {cnt=35, x=-45, y=-55}},
    },
    [156] = {
        [5]  = {"JetFighterRun", {arm="bomb"}},
        [10] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=46, intensity=12}},
		[11]  = {"Siren", {}},
        [15] = {"JetFighterRun", {arm="bomb"}},
		[23] = {"JetFighterRun", {arm="bomb"}},
        [24] = {"JetFighterRun", {arm="mg"}},
		[26] = {"PlaneCrashSequence", {}},
		[27] = {"JetFighterRun", {arm="bomb"}},
		[28] = {"JetFighterRun", {arm="bomb"}},
		[29] = {"JetFighterRun", {arm="gas"}},
		[30] = {"JetFighterRun", {arm="bomb"}},
		[31] = {"JetFighterRun", {arm="bomb"}},
		[32] = {"JetFighterRun", {arm="bomb"}},
		[33] = {"JetFighterRun", {arm="gas"}},
		[34] = {"JetFighterRun", {arm="bomb"}},
		[42] = {"Horde", {cnt=40, x=45, y=45}},
		[53] = {"Horde", {cnt=70, x=-45, y=45}},
		[38] = {"SpawnGroup", {name="Inmates", cid=Bandit.clanMap.InmateFree, program="Bandit", d=46, intensity=7}},
    },
    [158] = {
        [0]  = {"Siren", {}},
        [8]  = {"JetFighterRun", {arm="bomb"}},
        [9]  = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.Mental, program="Bandit", d=45, intensity=12}},
        [24] = {"JetFighterRun", {arm="mg"}},
        [31] = {"JetFighterRun", {arm="gas"}},
        [49] = {"JetFighterRun", {arm="gas"}},
        [51] = {"SetHydroPower", {on=false}},
        [52] = {"SetHydroPower", {on=true}},
        [53] = {"Horde", {cnt=100, x=45, y=45}},
		[56] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=45, intensity=5}},
    },
    [159] = {
        [8]  = {"JetFighterRun", {arm="bomb"}},
        [9]  = {"SetHydroPower", {on=false}},
        [10] = {"JetFighterRun", {arm="mg"}},
        [11] = {"SetHydroPower", {on=true}},
		[15] = {"SpawnGroup", {name="Mysterious Organization", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=4}},
        [24] = {"JetFighterRun", {arm="bomb"}},
        [25] = {"SetHydroPower", {on=false}},
        [27] = {"SetHydroPower", {on=true}},
        [49] = {"JetFighterRun", {arm="bomb"}},
    },
    [160] = {
        [8]  = {"JetFighterRun", {arm="bomb"}},
        [9]  = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=45, intensity=9}},
        [24] = {"JetFighterRun", {arm="mg"}},
        [25] = {"SetHydroPower", {on=false}},
        [26] = {"SetHydroPower", {on=true}},
        [49] = {"JetFighterRun", {arm="bomb"}},
        [51] = {"SetHydroPower", {on=false}},
        [53] = {"SetHydroPower", {on=true}},
        [54] = {"Horde", {cnt=100, x=45, y=-45}},
    },
    [161] = {
        [8]  = {"JetFighterRun", {arm="bomb"}},
        [24] = {"JetFighterRun", {arm="mg"}},
        [49] = {"JetFighterRun", {arm="bomb"}},
        [51] = {"SetHydroPower", {on=false}},
        [58] = {"SetHydroPower", {on=true}},
    },
    [162] = {
        [8]  = {"JetFighterRun", {arm="mg"}},
		[15] = {"SpawnGroup", {name="Mysterious Organization", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=6}},
        [24] = {"JetFighterRun", {arm="bomb"}},
        [49] = {"JetFighterRun", {arm="bomb"}},
        [50] = {"SetHydroPower", {on=false}},
        [51] = {"SetHydroPower", {on=true}},
		[55] = {"Horde", {cnt=40, x=45, y=45}},
        [68] = {"JetFighterRun", {arm="mg"}},
    },
    [163] = {
        [8]  = {"JetFighterRun", {arm="bomb"}},
        [15] = {"SpawnGroup", {name="Bandits", cid=Bandit.clanMap.BanditStrong, program="Bandit", d=45, intensity=5}},
        [24] = {"JetFighterRun", {arm="bomb"}},
        [30] = {"JetFighterRun", {arm="bomb"}},
        [43] = {"JetFighterRun", {arm="bomb"}},
        [45] = {"JetFighterRun", {arm="mg"}},
        [49] = {"JetFighterRun", {arm="bomb"}},
    },
    [164] = {
        [8]  = {"JetFighterRun", {arm="bomb"}},
        [9] = {"VehicleCrash", {x=22, y=-70, vtype="pzkA10wreck"}},
        [10] = {"SetHydroPower", {on=false}},
        [13] = {"SetHydroPower", {on=true}},
        [24] = {"JetFighterRun", {arm="bomb"}},
        [49] = {"JetFighterRun", {arm="bomb"}},
        [51] = {"VehicleCrash", {x=-32, y=60, vtype="pzkA10wreck"}},
    },
    [165] = {
        [2]  = {"ChopperFliers", {}},
        [18] = {"VehicleCrash", {x=2, y=70, vtype="pzkHeli350MedWreck"}},
    },
    [166] = {
        [4]  = {"SpawnGroup", {name="Hammer Brothers", cid=Bandit.clanMap.HammerBrothers, program="Bandit", d=50, intensity=2}},
		[10] = {"SpawnGroup", {name="Mysterious Organization", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=6}},
    },
    [168] = {
        [0]  = {"StartDay", {day="friday"}},
        [4]  = {"Siren", {}},
        [30] = {"FinalSolution", {}},
        [34] = {"SetHydroPower", {on=false}},
        [35] = {"Horde", {cnt=100, x=-45, y=45}},
    },
    [176] = {
        [25] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=4}},
    },
    [177] = {
        [25] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=4}},
    },
    [189] = {
        [12] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=7}},
    },
    [192] = {
        [33] = {"Horde", {cnt=100, x=45, y=-45}},
    },
    [211] = {
        [44] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=8}},
    },
    [235] = {
        [3] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=8}},
    },
    [236] = {
        [12] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=8}},
    },
    [253] = {
        [42] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=10}},
    },
    [315] = {
        [11] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=10}},
        [30] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=10}},
    },
    [333] = {
        [4] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=5}},
    },
    [376] = {
        [4] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=10}},
    },
    [400] = {
        [32] = {"SpawnGroup", {name="Sweeper Squad", cid=Bandit.clanMap.Sweepers, program="Bandit", d=60, intensity=10}},
    },
}

table.insert(BWOVariants, soldier)
